function [LinSol] = LinFun(K,U)

%Linear approximation for TGFB
S4n_0 = K.S4tot*(K.kin4/(K.kex4+K.kin4/K.a));
Beta = K.PPase*K.kdephos/(K.kphos*K.Rtot*(K.kex2/(K.a*K.kex2+K.kin2)));
gamma = K.a*(K.a*K.kex2+K.PPase*K.kdephos)*(1/(K.a*K.kex2)+1/(K.CIF*K.kin2));
alpha = K.a*(K.kon*S4n_0+K.a*K.kex2)/K.koff;
LinSol = K.a*alpha*(U)./(Beta)*K.S2tot;

end